/* ************************************************************************** */
/* Example of a syndication feed reader using the Project Rome API            */
/* current version of Rome: rome1.0.jar            https://rome.dev.java.net/ */
/* You need to implement this API plus the JDOM API                           */
/* jdom.jar  ,   you can find this at               https://jdom.org/         */
/* Parts of this example are taken from the PRome Web Page tutorials          */
/* https://rome.dev.java.net/ thanks to author:   Alejandro Abdelnur          */
/*                                                                            */
/* This code is used to create feeds in different formats.                    */
/* The created feed will be printed to the system.                            */
/* created by Martin Stoppacher       date:  26.12.2009                       */
/* license:    LGPL 3.0                                                       */
/*             (Lesser Gnu Public License version 3.0),                       */
/*             cf. <http://www.gnu.org/licenses/lgpl.html>                    */
/* ************************************************************************** */  
import com.sun.syndication.feed.synd.*;
/* imports the whole package:(interfaces: Converter,SyndCategory,SyndContent  */
/* SyndEnclosure,SyndEntry,SyndFeed,SyndImage SyndLink,SyndPerson             */
/* Classes: SyndCategoryImpl, SyndContentImpl, SyndEnclosureImpl	      */
/* SyndEntryImpl, SyndFeedImpl, SyndImageImpl, SyndLinkImpl SyndPersonImpl    */
import com.sun.syndication.io.SyndFeedOutput;
/* Generates an XML document(String, File, OutputStream, Writer,              */
/* W3C DOM document or JDOM document)out of an SyndFeedImpl                   */

import java.io.FileWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.io.PrintWriter;

public class 8_FeedCreator {

    private static final DateFormat 
                DATE_PARSER = new SimpleDateFormat("yyyy-MM-dd");

    public static void main(String[] args) {
        boolean ok = false;
        if (args.length==1) {
            try {
                String feedType = args[0]; 
                /*              creates a string with the filetype Information*/
                //String fileName = args[1]; 
                /*                creates a string with the filename to write */

                SyndFeed feed = new SyndFeedImpl();          /*new feed object*/
                feed.setFeedType(feedType);      /*define the type of the feed*/

                feed.setTitle("This is a simple Sample");
                feed.setLink("martinstoppacher.com");
                feed.setDescription("My favorite webpages; format:_"+feedType);

                List entries = new ArrayList();       /* entries array object */
                SyndEntry entry;
                SyndContent description;

                entry = new SyndEntryImpl();                /* entry opbject  */
                entry.setTitle("The Project Rome Web Page");
                /*                                 shows feed type in the feed*/
                entry.setLink("https://rome.dev.java.net/");
                entry.setPublishedDate(DATE_PARSER.parse("2009-12-26"));
                description = new SyndContentImpl(); /*    description object */
                description.setType("text/plain");
                description.setValue("ROME Web Page");
                entry.setDescription(description);  
                /*             add the description object to the entry object */
                entries.add(entry); 
                /*                adds the entry object to the entries array  */

                entry = new SyndEntryImpl();       /* an other entry opbject  */
                entry.setTitle("Java 1.4 Documentation");
                entry.setLink("http://java.sun.com/j2se/1.4.2/docs/api/");
                entry.setPublishedDate(DATE_PARSER.parse("2009-12-26"));
                description = new SyndContentImpl();
                description.setType("text/plain");
                description.setValue("Documentation of the Java 1.4 API");
                entry.setDescription(description);
                entries.add(entry);

                entry = new SyndEntryImpl();        /* an other entry opbject */
                entry.setTitle("The ooRexx Web Page");
                entry.setLink("http://www.oorexx.org/");
                entry.setPublishedDate(DATE_PARSER.parse("2009-12-26"));
                description = new SyndContentImpl();
                description.setType("text/html");
                description.setValue("<p>Open Object Rexx version 4.0.0 is now"
                                    +" available. Visit the announcement page" 
                                    +" for More information.</p><p>For details"
                                    +" check the <a href=\"http://www.oo"
                                    +"rexx.org/\">ooRexx Web Page</a></p>");
                
                entry.setDescription(description);
                entries.add(entry);

                feed.setEntries(entries); 
                /*                         add the entries array to the  feed */

                SyndFeedOutput output = new SyndFeedOutput();  /* putput part */
                output.output(feed,new PrintWriter(System.out));

                /*                                       // optional writer part
                Writer writer = new FileWriter(fileName);
                SyndFeedOutput output = new SyndFeedOutput();
                output.output(feed,writer);
                writer.close();

                System.out.println("The feed has been"
                                  +" written to the file ["+fileName+"]");               
                */
                
                ok = true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.out.println("ERROR: "+ex.getMessage());
            }
        }
        if (!ok) {
            System.out.println();
            System.out.println("FeedWriter creates a RSS/Atom feed and" 
                              +" writes it to a file.");
            System.out.println("The first parameter must be the" 
                              +" syndication format for the feed");
            System.out.println("  (rss_0.90, rss_0.91, rss_0.92, rss_0.93,"
                              +" rss_0.94, rss_1.0 rss_2.0 or atom_0.3)");
            System.out.println();
        }
    }

}